// gmnview32.cpp : Legt das Klassenverhalten fr die Anwendung fest.
//

#include "stdafx.h"
#include "gmnview32.h"

#include "MainFrm.h"
#include "ChildFrm.h"
#include "gmnview32Doc.h"
#include "gmnview32View.h"
#include "VirtualPageDialog.h"
#include "MyHTMLDoc.h"
#include "MyHTMLView.h"
#include "HelpDialog.h"
#include "SpringDialog.h"
#include "SpacingDialog.h"
#include "M2GConvDialog.h"
#include "..\midi2gmn_dll\m2gmn_dll.h"
#include "MDConvLog.h"
#include <afxadv.h>

#include <io.h>
#include <fstream.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// deklarationen fuer nview32
extern "C" {
	_declspec (dllimport) void getDefaultPageSize
		(float *sx,float *sy,float *ml, float *mt,
		float *mr, float *mb);
	_declspec (dllimport) void setDefaultPageSize(
		char *sizex,char *sizey,
		char *mleft, char *mtop, char *mright,
		char *mbottom);
	_declspec (dllimport) void getPageSize
		(int handle,float *sx,float *sy,float *ml, float *mt,
		float *mr, float *mb);
	_declspec (dllimport) void getSpringParameter(float *npar);
	_declspec (dllimport) void setSpringParameter(float npar);
	_declspec (dllimport) void setSetting(int setting,float npar);
	_declspec (dllimport) void getSetting(int setting, float *npar);
	_declspec (dllimport) int getVersionStr(char *str,int length);
	_declspec (dllimport) float GetOptForce();
	_declspec (dllimport) void SetOptForce(float newoptforce);
	_declspec (dllimport) int GetOptPageFill();
	_declspec (dllimport) void SetOptPageFill(int newoptpagefill,int update);
	_declspec (dllimport) int GetNeighborhoodSpacing();
	_declspec (dllimport) void SetNeighborhoodSpacing(int neighbor,int update);
	_declspec (dllimport) int CheckHandle(int handle);


}

_declspec (dllimport) int md2gmn(int argc,char **argv,const char * logfilename);

/////////////////////////////////////////////////////////////////////////////
// CGmnview32App

BEGIN_MESSAGE_MAP(CGmnview32App, CWinApp)
	//{{AFX_MSG_MAP(CGmnview32App)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_VIRTUALPAGE, OnFileVirtualpage)
	ON_COMMAND(ID_FILE_PRINT_SETUP, OnFilePrintSetup)
	ON_UPDATE_COMMAND_UI(ID_FILE_NEW, OnUpdateFileNew)
	ON_COMMAND(ID_HELP, OnHelp)
	ON_COMMAND(ID_FILE_SPRINGPARAMETERS, OnFileSpringparameters)
	ON_COMMAND(ID_VOICECREATESRODS, OnVoicecreatesrods)
	ON_UPDATE_COMMAND_UI(ID_VOICECREATESRODS, OnUpdateVoicecreatesrods)
	ON_COMMAND(ID_SPRINGANDROD, OnSpringandrod)
	ON_UPDATE_COMMAND_UI(ID_SPRINGANDROD, OnUpdateSpringandrod)
	ON_COMMAND(ID_STAFFCREATESRODS, OnStaffcreatesrods)
	ON_UPDATE_COMMAND_UI(ID_STAFFCREATESRODS, OnUpdateStaffcreatesrods)
	ON_COMMAND(ID_SORTELEMENTS, OnSortElements)
	ON_UPDATE_COMMAND_UI(ID_SORTELEMENTS, OnUpdateSortElements)
	ON_COMMAND(ID_FILE_OPENEXAMPLES, OnFileOpenexamples)
	ON_COMMAND(ID_FILE_ADJUSTSPACINGPARAMETERS, OnFileAdjustspacingparameters)
	ON_COMMAND(ID_FILE_IMPORTMIDIFILE, OnFileImportmidifile)
	ON_COMMAND(ID_FILE_IMPORTMUSEDATAFLE, OnFileImportmusedatafle)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_VIEW_DISPLAY_FORCE, OnViewDisplayForce)
	ON_UPDATE_COMMAND_UI(ID_VIEW_DISPLAY_FORCE, OnUpdateViewDisplayForce)
	//}}AFX_MSG_MAP
	// Dateibasierte Standard-Dokumentbefehle
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard-Druckbefehl "Seite einrichten"
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGmnview32App Konstruktion

CGmnview32App::CGmnview32App()
{
	// ZU ERLEDIGEN: Hier Code zur Konstruktion einfgen
	// Alle wichtigen Initialisierungen in InitInstance platzieren
}

/////////////////////////////////////////////////////////////////////////////
// Das einzige CGmnview32App-Objekt

CGmnview32App theApp;

/////////////////////////////////////////////////////////////////////////////
// CGmnview32App Initialisierung

BOOL CGmnview32App::InitInstance()
{
	AfxEnableControlContainer();

	// Standardinitialisierung
	// Wenn Sie diese Funktionen nicht nutzen und die Gre Ihrer fertigen 
	//  ausfhrbaren Datei reduzieren wollen, sollten Sie die nachfolgenden
	//  spezifischen Initialisierungsroutinen, die Sie nicht bentigen, entfernen.

#ifdef _AFXDLL
	Enable3dControls();			// Diese Funktion bei Verwendung von MFC in gemeinsam genutzten DLLs aufrufen
#else
	Enable3dControlsStatic();	// Diese Funktion bei statischen MFC-Anbindungen aufrufen
#endif

	// ndern des Registrierungsschlssels, unter dem unsere Einstellungen gespeichert sind.
	// Sie sollten dieser Zeichenfolge einen geeigneten Inhalt geben
	// wie z.B. den Namen Ihrer Firma oder Organisation.
	SetRegistryKey(_T("sic!systems"));

	LoadStdProfileSettings();  // Standard-INI-Dateioptionen einlesen (einschlielich MRU)

	// Dokumentvorlagen der Anwendung registrieren. Dokumentvorlagen
	//  dienen als Verbindung zwischen Dokumenten, Rahmenfenstern und Ansichten.

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_GMNVWTYPE,
		RUNTIME_CLASS(CGmnview32Doc),
		RUNTIME_CLASS(CChildFrame), // Benutzerspezifischer MDI-Child-Rahmen
		RUNTIME_CLASS(CGmnview32View));
	AddDocTemplate(pDocTemplate);

	/*pDocTemplate = new CMultiDocTemplate(
		IDR_HTMLTYPE,
		RUNTIME_CLASS(CMyHTMLDoc),
		RUNTIME_CLASS(CChildFrame),
		RUNTIME_CLASS(CMyHTMLView));
	AddDocTemplate(pDocTemplate);*/

	// Hier kann mann auch den SplitterWindow-Doctype
	// dazunehmen ...

	// Haupt-MDI-Rahmenfenster erzeugen
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// ffnen per DragDrop aktivieren
	m_pMainWnd->DragAcceptFiles();

	// DDE-Execute-Open aktivieren
	EnableShellOpen();
	RegisterShellFileTypes(TRUE);

	// Befehlszeile parsen, um zu prfen auf Standard-Umgebungsbefehle DDE, Datei offen
	CCommandLineInfo cmdInfo;
	cmdInfo.m_nShellCommand = CCommandLineInfo::FileNothing;
	ParseCommandLine(cmdInfo);

	// Verteilung der in der Befehlszeile angegebenen Befehle
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// Das Hauptfenster ist initialisiert und kann jetzt angezeigt und aktualisiert werden.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	// these parameters should be read out from
	// Registry-Entries ....
	getDefaultPageSize(&vpsx,&vpsy,&vpml,&vpmt,
		&vpmr,&vpmb);

	vpignorepf = 0;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg-Dialogfeld fr Anwendungsbefehl "Info"

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

	// Dialogfelddaten
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CString	m_versionstring;
	CString	m_nviewversion;
	//}}AFX_DATA

	// Vom Klassenassistenten generierte berladungen virtueller Funktionen
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	//}}AFX_VIRTUAL

// Implementierung
protected:
	//{{AFX_MSG(CAboutDlg)
		// Keine Nachrichten-Handler
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	m_versionstring = _T("");
	m_nviewversion = _T("");
	//}}AFX_DATA_INIT

	char buffer[200];
	// takes the version form nview32.dll
	getVersionStr(buffer,200);


	m_versionstring = buffer;

	this->m_nviewversion = "0.9 (" __DATE__  ")";
		

}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Text(pDX, IDC_VERSIONSTRING, m_versionstring);
	DDX_Text(pDX, IDC_NVIEWVERSION, m_nviewversion);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// Keine Nachrichten-Handler
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Anwendungsbefehl, um das Dialogfeld aufzurufen
void CGmnview32App::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CGmnview32App-Befehle


void CGmnview32App::OnFileVirtualpage() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen

	// changeable...
	CVirtualPageDialog vpdg(NULL,vpsx,vpsy,
		vpml,vpmt,vpmr,vpmb,0,0,0,0,0,0);

	vpdg.m_ignorePF = vpignorepf;

	vpdg.setOnlyDefault(true);

	if (vpdg.DoModal() == IDOK)
	{
		vpdg.getMargins(true,&vpsx,&vpsy,&vpml,
			&vpmt,&vpmr,&vpmb);
		vpignorepf = vpdg.m_ignorePF;
		
		char * svpsx = new char[20];
		sprintf(svpsx,"%.3fcm",vpsx);
		
		char * svpsy = new char[20];
		sprintf(svpsy,"%.3fcm",vpsy);
		
		char * svpml = new char[20];
		sprintf(svpml,"%.3fcm",vpml);
		
		char * svpmb = new char[20];
		sprintf(svpmb,"%.3fcm",vpmb);
		
		char * svpmt = new char[20];
		sprintf(svpmt,"%.3fcm",vpmt);
		
		char * svpmr = new char[20];
		sprintf(svpmr,"%.3fcm",vpmr);
		
		setDefaultPageSize(svpsx,svpsy,svpml,svpmt,svpmr,svpmb);

		delete [] svpsx;
		delete [] svpsy;
		delete [] svpml;
		delete [] svpmt;
		delete [] svpmr;
		delete [] svpmb;

		float tstx,tsty,tstml,tstmt,tstmr,tstmb;
		getDefaultPageSize(&tstx,&tsty,
			&tstml,&tstmt,&tstmr,&tstmb);
		if ((int) (vpsx * 100) != (int) (tstx * 100) ||
			vpsy != tsty ||
			vpml != tstml ||
			vpmt != tstmt ||
			vpmr != tstmr ||
			vpmb != tstmb)
		{
			MessageBox(NULL,"The Values that you have entered are not correct. They will be adjustet automatically!","WARNING",MB_OK);
			vpsx = tstx;
			vpsy = tsty;
			vpml = tstml;
			vpmt = tstmt;
			vpmr = tstmr;
			vpmb = tstmb;
		}
	}
	
}



void CGmnview32App::OnFilePrintSetup() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	CPrintDialog pd(TRUE);
	int res = DoPrintDialog(&pd);
	if (res == IDOK)
	{
		// now ask, wether we want to adjust page
		// sizes ...
		// maybe not now ... in the next version ..
	}

}

/* void CGmnview32App::OnFileNew() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen

	return; // do nothing ...
	
} */

void CGmnview32App::OnUpdateFileNew(CCmdUI* pCmdUI) 
{
	// TODO: Code fr die Befehlsbehandlungsroutine zum Aktualisieren der Benutzeroberflche hier einfgen
//	pCmdUI->Enable(false);	
}

void CGmnview32App::DisplayHTMLWindow()
{
	/* ... this needs to be rethought .... 
	CDocTemplate *pTemplate = new CMultiDocTemplate(
		IDR_HTMLTYPE,
		RUNTIME_CLASS(CMyHTMLDoc),
		RUNTIME_CLASS(CChildFrame),
		RUNTIME_CLASS(CMyHTMLView));
	AddDocTemplate(pDocTemplate);

	pTemplate->OpenDocumentFile(NULL);

	delete pTemplate; */

}


void CGmnview32App::OnHelp() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	CHelpDialog helpdlg;
	helpdlg.DoModal();
}

void CGmnview32App::OnFileSpringparameters() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen

	CSpringDialog sprdlg;
	if (sprdlg.DoModal() == IDOK)
	{
		// hourglass
		HCURSOR old = ::SetCursor(::LoadCursor(NULL,IDC_WAIT));

		setSpringParameter(sprdlg.springpar);

		POSITION pos = GetFirstDocTemplatePosition();
		while(pos)
		{
			CDocTemplate* pTemplate = GetNextDocTemplate(pos); 
			POSITION pos2 = pTemplate->GetFirstDocPosition();
			while(pos2)
			{
				CDocument* pDocument;
				if(pDocument = pTemplate->GetNextDoc(pos2))
				{
					CGmnview32Doc *mydoc = dynamic_cast<CGmnview32Doc *>(pDocument);
					if (mydoc)
					{
						mydoc->checkMusicHandle();
						POSITION viewpos = mydoc->GetFirstViewPosition();
						while (viewpos)
						{
							CGmnview32View *myview = 
								dynamic_cast<CGmnview32View *>(
								mydoc->GetNextView(viewpos));
							if (myview)
							{
								myview->updatePage(mydoc->getMusicHandle());
								myview->InvalidateRect(NULL);
							}
						}
					}
				}
			}
		}

		/* old
		CFrameWnd *myframe = 
			dynamic_cast<CFrameWnd *>(m_pMainWnd);
		if (myframe)
		{
			CMDIFrameWnd *pFrame = 
             (CMDIFrameWnd*)AfxGetApp()->m_pMainWnd;

			// Get the active MDI child window.
			CMDIChildWnd *pChild = 
				 (CMDIChildWnd *) pFrame->GetActiveFrame();

			// or CMDIChildWnd *pChild = pFrame->MDIGetActive();

			// Get the active view attached to the active MDI child
			// window.
			if (pChild)
			{
						CGmnview32View * mychild = dynamic_cast<CGmnview32View *>(pChild->GetActiveView());
			if (mychild)
			{
				mychild->updatePage(mychild->GetDocument()->getMusicHandle());
				//			mychild->updateScrollBars();
			}
			}


			

			// CWnd *wnd = myframe->GetActiveView();


			HWND tmp = (HWND) *pChild;
			while ( tmp != NULL)
			{
				::InvalidateRect(tmp,NULL,TRUE);
				tmp = ::GetNextWindow(tmp,GW_HWNDNEXT);
			}
		}
		*/

		::SetCursor(old);
	}
}

void CGmnview32App::OnVoicecreatesrods() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	float f;
	getSetting(2,&f);
	if (f != (float) 2)
	{
		setSetting(2,(float) 2);	
		// recalculate ...
	}
}

void CGmnview32App::OnUpdateVoicecreatesrods(CCmdUI* pCmdUI) 
{
	// TODO: Code fr die Befehlsbehandlungsroutine zum Aktualisieren der Benutzeroberflche hier einfgen
	float f;
	getSetting(2,&f);
	if ( (int) f == 2)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);
	
}

void CGmnview32App::OnSpringandrod() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen

	float f;
	getSetting(1,&f);
	
	if (f == (float) 1)
	{
	// determine if checked ? how to?
		setSetting(1,(float) 0);	
		// do a redisplay ...

	}
	else
	{
		setSetting(1,(float) 1);
		// refresh the view ...
	}

	
}

void CGmnview32App::OnUpdateSpringandrod(CCmdUI* pCmdUI) 
{
	// TODO: Code fr die Befehlsbehandlungsroutine zum Aktualisieren der Benutzeroberflche hier einfgen
	float f;
	getSetting(1,&f);
	if ( (int) f == 1)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);
	
}

void CGmnview32App::OnStaffcreatesrods() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	float f;
	getSetting(2,&f);
	if (f != (float) 1)
	{
		setSetting(2,(float) 1);
		// ein reparse muss stattfinden ...
		// und ein redisplay ...

	}
}

void CGmnview32App::OnUpdateStaffcreatesrods(CCmdUI* pCmdUI) 
{
	// TODO: Code fr die Befehlsbehandlungsroutine zum Aktualisieren der Benutzeroberflche hier einfgen

	float f;
	getSetting(2,&f);
	if ( (int) f == 1)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);
}

void CGmnview32App::OnSortElements() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	float f;
	getSetting(3,&f);
	if (f == (float) 1)
	{
		setSetting(3,(float) 0);
		// ein reparse muss stattfinden ...
		// und ein redisplay ...
	}
	else
		setSetting(3,(float) 1);
}

void CGmnview32App::OnUpdateSortElements(CCmdUI* pCmdUI) 
{
	// TODO: Code fr die Befehlsbehandlungsroutine zum Aktualisieren der Benutzeroberflche hier einfgen

	float f;
	getSetting(3,&f);
	if ( (int) f == 1)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);
}

void CGmnview32App::OnFileOpenexamples() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	// This opens a fileopen dialog box with the examples-directory
	// already open ...

	char tmp[MAX_PATH];
	GetModuleFileName(NULL,tmp,MAX_PATH);

	CString pathName(tmp);
	pathName = pathName.Left(
		pathName.ReverseFind('\\'));

	pathName += "\\examples\\";

	CFileDialog fileDialog(TRUE,NULL,NULL,OFN_HIDEREADONLY | OFN_FILEMUSTEXIST,
		"GUIDO Music Notation (*.gmn)|*.gmn||",this->GetMainWnd());

	fileDialog.m_ofn.lpstrTitle = "Open Example File";
	fileDialog.m_ofn.lpstrInitialDir = pathName;

	if (fileDialog.DoModal() == IDOK)
	{
		OpenDocumentFile(fileDialog.GetFileName());
	}
 
}

void CGmnview32App::OnFileAdjustspacingparameters() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	
	CSpacingDialog sd;
	
	
	
	float curoptforce = GetOptForce();
	
	// left side equals a force of 400
	// right side equals a force of 1600
	
	int oldpagefill = GetOptPageFill();
	int oldneighbor = GetNeighborhoodSpacing();

	float defsysdis;
	getSetting(4,&defsysdis);
	
	if (sd.DoModal() == IDOK)
	{
		
		SetNeighborhoodSpacing(sd.m_specialspacing,0);
		SetOptPageFill(sd.m_optpagefill,0);
	
		if (sd.m_def_sys_dis_changed)
		{
		float newdefsysdis = (float) sd.m_def_sys_dis / 100.0;
		setSetting(4,newdefsysdis);
		}

		float sysdistribution = sd.m_dis_auto + 1;
		setSetting(5,sysdistribution);
		
		float newoptforce = sd.m_optforceint;
		SetOptForce(newoptforce);
		
		// now we need to go through ALL document windows ...
		
		POSITION pos = GetFirstDocTemplatePosition();
		while(pos)
		{
			CDocTemplate* pTemplate = GetNextDocTemplate(pos); 
			POSITION pos2 = pTemplate->GetFirstDocPosition();
			while(pos2)
			{
				CDocument* pDocument;
				if(pDocument = pTemplate->GetNextDoc(pos2))
				{
					CGmnview32Doc *mydoc = dynamic_cast<CGmnview32Doc *>(pDocument);
					if (mydoc)
					{
						mydoc->checkMusicHandle();
						POSITION viewpos = mydoc->GetFirstViewPosition();
						while (viewpos)
						{
							CGmnview32View *myview = 
								dynamic_cast<CGmnview32View *>(
								mydoc->GetNextView(viewpos));
							if (myview)
							{
								myview->updatePage(mydoc->getMusicHandle());
								myview->InvalidateRect(NULL);
							}
						}
					}
				}
			}
		}
		
		
		
		/* old
		
		  CMDIFrameWnd *pFrame = 
		  (CMDIFrameWnd*)AfxGetApp()->m_pMainWnd;
		  
			// Get the active MDI child window.
			CMDIChildWnd *pChild = 
			(CMDIChildWnd *) pFrame->GetActiveFrame();
			if (pChild)
			{
			CGmnview32View * mychild = dynamic_cast<CGmnview32View *>(pChild->GetActiveView());
			if (mychild)
			{
			mychild->updatePage(mychild->GetDocument()->getMusicHandle());
			//			mychild->updateScrollBars();
			}
			}
			HWND tmp = (HWND) *pChild;
			while ( tmp != NULL)
			{
			::InvalidateRect(tmp,NULL,TRUE);
			tmp = ::GetNextWindow(tmp,GW_HWNDNEXT);
			}
		*/
		
	}
	
	
}


/* void CGmnview32App::OnFileOptpagefill() 
{
// TODO: Code fr Befehlsbehandlungsroutine hier einfgen

  int optpage = GetOptPageFill();
  if ( optpage == 1)
		SetOptPageFill(0);
		else
		SetOptPageFill(1);
		
		  CMDIFrameWnd *pFrame = 
		  (CMDIFrameWnd*)AfxGetApp()->m_pMainWnd;
		  
			// Get the active MDI child window.
			CMDIChildWnd *pChild = 
			(CMDIChildWnd *) pFrame->GetActiveFrame();
			if (pChild)
			{
			CGmnview32View * mychild = dynamic_cast<CGmnview32View *>(pChild->GetActiveView());
			if (mychild)
			{
			mychild->updatePage(mychild->GetDocument()->getMusicHandle());
			//			mychild->updateScrollBars();
			}
			}
			HWND tmp = (HWND) *pChild;
			while ( tmp != NULL)
			{
			::InvalidateRect(tmp,NULL,TRUE);
			tmp = ::GetNextWindow(tmp,GW_HWNDNEXT);
			}
			
			  }
			  */
			  
			  BOOL CALLBACK chldenumproc(HWND hwnd,LPARAM lparm)
			  {
				  // inside ...
				  char wndtxt[255];
				  ::GetWindowText(hwnd,wndtxt,254);
				  return TRUE;
			  }
			  
void CGmnview32App::OnFileImportmidifile() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	CFileDialog fileDialog(TRUE,NULL,NULL,OFN_FILEMUSTEXIST,
		"MIDI file(*.mid)|*.mid||",this->GetMainWnd());
	
	fileDialog.m_ofn.lpstrTitle = "Import MIDI File";
	// 	fileDialog.m_ofn.lpstrInitialDir = pathName;
	
	if (fileDialog.DoModal() == IDOK)
	{
		// now we have a MIDI file ....
		
		// hourglass
		HCURSOR old = ::SetCursor(::LoadCursor(NULL,IDC_WAIT));
		
		
		char tmp[MAX_PATH];
		char tmppath[MAX_PATH];
		GetModuleFileName(NULL,tmp,MAX_PATH);
		
		CString pathName(tmp);
		pathName = pathName.Left(
			pathName.ReverseFind('\\'));
		
		CString iniName;
		iniName = pathName + "\\fermata.INI";
		
		
		CString midifilename(fileDialog.GetPathName());
		CString midifilepath = midifilename.Left(
			midifilename.ReverseFind('\\'));
		
		CString midifiletitle;
		midifiletitle = fileDialog.GetFileTitle();
		
		// create a temporary name for the GMN-File ....
		char tmpname[MAX_PATH];
		CString tmpgmnname;
		// create a temporary name until there is really no file
		// with that name ...
		
		::GetTempPath(MAX_PATH,tmppath);
		
		int i = 3245;
		do
		{
			::GetTempFileName(tmppath,"m2g_",i++,tmpname);
			tmpgmnname = CString(tmpname) +  ".gmn";
		}
		while (_access(tmpgmnname,04)==0);
		
		
		BOOL resbool;
		
		int logfilemoved = 0;
		CString movedlogfilename(tmpname);
		movedlogfilename += ".log";
		
		CString logfilename(midifilepath);
		
		
		logfilename += "\\" + midifiletitle + ".LOG";
		
		// if there already is a file with the logfilename
		// we move it to a temporary place  ....
		if (!_access(logfilename,0))
		{
			// there is a file 
			
			resbool = ::MoveFile(logfilename,movedlogfilename);
			if (resbool)
				logfilemoved = 1;
			
		}
		
		int result = midi2gmn(iniName,fileDialog.GetPathName(),tmpgmnname);
		if (!result)
		{
			
			// the conversion was successfull
			
			// this list saves the currently open MDI window names 
			CStringList mylist;
			
			// before we open the (temporary) gmnfile
			// we iterate through the already open MDI-Files
			// to save the names in a StringList ...
			// Iteration works as follows: the GetWindow function can
			// be used to retrieve the child-windows of the MDI-Client
			// window, which is the first (and only) child of the FrameWindow
			/* old stuff!
			new stuff works with document routines ...
			CMainFrame *mf = dynamic_cast<CMainFrame *>(GetMainWnd());
			CWnd *cf = NULL;
			if (mf)
			{
			// the first child of the MinFrame is CMDIFrame
			cf = mf->GetWindow(GW_CHILD);
			if (cf)
			{
			// the first child of CMIDFrame is MDIClient ...
			// now this is the MDI client ....
			
			  
				cf = cf->GetWindow(GW_CHILD);
				// cf is now the first child of the MDI Client window
				
				  while (cf)
				  {
				  // now we iterate through the children ...
				  CString mytxt;
				  cf->GetWindowText(mytxt);
				  
					// the name is added to the search list ....
					mylist.AddTail(mytxt);
					cf =  (cf->GetWindow(GW_HWNDNEXT));
					}
					}
						  }*/
			POSITION pos = GetFirstDocTemplatePosition();
			while(pos)
			{
				CDocTemplate* pTemplate = GetNextDocTemplate(pos); 
				POSITION pos2 = pTemplate->GetFirstDocPosition();
				while(pos2)
				{
					CDocument* pDocument;
					if(pDocument = pTemplate->GetNextDoc(pos2))
					{
						CGmnview32Doc *mydoc = dynamic_cast<CGmnview32Doc *>(pDocument);
						
						if (mydoc)
						{
							CString mystr = mydoc->GetTitle();
							mylist.AddTail(mystr);
						}
					}
				}
			}
			
			
			
			
			// the temporary gmn-file is opened as a new document
			CGmnview32Doc *mydoc = dynamic_cast
				<CGmnview32Doc *>(OpenDocumentFile(tmpgmnname));
			
			// this removes the temporary file from the MRU-List.
			// which is good, because it is only a temporary file
			m_pRecentFileList->Remove(0);
			
			
			// now we try to determine an unused filename ...			
			char chosenname[MAX_PATH];
			
			int i = 0;
			while (true)
			{
				
				// first, we check if the name is already used in
				// the open window file list ....
				char mytmpchar1[MAX_PATH];
				char mytmpchar2[MAX_PATH];
				if (i>0)
				{
					// one variation with star, the other without star
					sprintf(mytmpchar1,"%s%d.gmn *",midifiletitle,i);
					sprintf(mytmpchar2,"%s%d.gmn",midifiletitle,i);
				}
				else
				{
					sprintf(mytmpchar1,"%s.gmn *",midifiletitle);
					sprintf(mytmpchar2,"%s.gmn",midifiletitle);
				}
				
				if (mylist.Find(mytmpchar1) || mylist.Find(mytmpchar2))
				{
					i++;
					continue;
				}
				
				if (i != 0)
					sprintf(chosenname,"%s\\%s%d.gmn",midifilepath,
					midifiletitle,i);
				else 
					sprintf(chosenname,"%s\\%s.gmn",midifilepath,
					midifiletitle);
				
				
				if (_access(chosenname,04) == -1)
					break;
				i++;
				if (i == 100)
				{
					sprintf(chosenname,"%s\\fresh_converted.gmn",pathName);
					break;
				}
			}
			
			mydoc->SetTitle(chosenname);
			mydoc->SetPathName(chosenname,FALSE);
			mydoc->SetModifiedFlag(TRUE);
			
			resbool = ::DeleteFile(tmpgmnname);
			
			
			// we display the logfile ....
			CM2GConvDialog cd;
			
			int linecountmax = 40;
			int dlgend = 1;
			int fulllog = 0;
			do
			{
				if (!fulllog)
					cd.m_isfulllog = 0;
				else
					cd.m_isfulllog = 1;
				cd.m_logtext = "";
				dlgend = 1;
				// read the logtext from the logfile ....
				CString line;
				CStdioFile mylfile(logfilename,CFile::modeRead);
				
				// the first 40 lines of the file ....
				int linecount = 0;
				while (mylfile.ReadString(line) && linecount < linecountmax)
				{
					linecount++;
					cd.m_logtext += line;
					cd.m_logtext += "\r\n";
				}
				
				mylfile.Close();
				
				if (cd.DoModal() == IDC_FULLLOG)
				{
					
					fulllog = 1;
					dlgend = 0;
					linecountmax = 20000;
				}
				
			}
			while (!dlgend);
			
		}
		
		// we also remove the log-file ...
		resbool = ::DeleteFile(logfilename);
		
		if (logfilemoved)
		{
			resbool = ::MoveFile(movedlogfilename,logfilename);
		}
		
		::SetCursor(old);
		
	} // if (fileDialog.OK);
	
}

void CGmnview32App::OnFileImportmusedatafle() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	CFileDialog fileDialog(TRUE,NULL,NULL,OFN_FILEMUSTEXIST,
		"MuseData file(*.md)|*.md||",this->GetMainWnd());
	
	fileDialog.m_ofn.lpstrTitle = "Import MuseData File";
	// 	fileDialog.m_ofn.lpstrInitialDir = pathName;
	
	if (fileDialog.DoModal() == IDOK)
	{
		// now we have a MIDI file ....
		
		// hourglass
		HCURSOR old = ::SetCursor(::LoadCursor(NULL,IDC_WAIT));
		
		
		char tmp[MAX_PATH];
		char tmppath[MAX_PATH];
		GetModuleFileName(NULL,tmp,MAX_PATH);
		
		CString pathName(tmp);
		pathName = pathName.Left(
			pathName.ReverseFind('\\'));
				
		
		CString mdfilename(fileDialog.GetPathName());
		CString mdfilepath = mdfilename.Left(
			mdfilename.ReverseFind('\\'));
		
		CString mdfiletitle;
		mdfiletitle = fileDialog.GetFileTitle();
		
		// create a temporary name for the GMN-File ....
		char tmpname[MAX_PATH];
		CString tmpgmnname;
		// create a temporary name until there is really no file
		// with that name ...
		
		::GetTempPath(MAX_PATH,tmppath);
		
		int i = 3245;
		do
		{
			::GetTempFileName(tmppath,"m2g_",i++,tmpname);
			tmpgmnname = CString(tmpname) +  ".gmn";
		}
		while (_access(tmpgmnname,04)==0);
		
		
		BOOL resbool;
		

		CString logfilename;
		i = 7864;
		do
		{
			::GetTempFileName(tmppath,"m2g_",i++,tmpname);
			logfilename = CString(tmpname) +  ".log";
		}
		while (_access(logfilename,04)==0);
		
		// we have to create the parameters for 
		// the call to md2gmn(int argc,char **argv)

		int argc = 3;
		char * argv[4];

		argv[0] = (char *) malloc(10);
		strcpy(argv[0],"md2gmn");
		argv[1] = (char *) malloc(MAX_PATH+10);
		sprintf(argv[1],"o%s",tmpgmnname);
		argv[2] = (char *) malloc(MAX_PATH);
		strncpy(argv[2],fileDialog.GetPathName(),MAX_PATH);
		argv[3] = NULL;

		// how can i redirect stdio?

		/* Reassign "stderr" to "freopen.out": */
		
		int result = md2gmn(argc,argv,logfilename);


		free(argv[2]);
		free(argv[1]);
		free(argv[0]);
		
		if (!result)
		{
			
			// the conversion was successfull
			
			// this list saves the currently open MDI window names 
			CStringList mylist;
			
			// before we open the (temporary) gmnfile
			// we iterate through the already open MDI-Files
			// to save the names in a StringList ...
			// Iteration works as follows: the GetWindow function can
			// be used to retrieve the child-windows of the MDI-Client
			// window, which is the first (and only) child of the FrameWindow
			/* old stuff!
			new stuff works with document routines ...
			CMainFrame *mf = dynamic_cast<CMainFrame *>(GetMainWnd());
			CWnd *cf = NULL;
			if (mf)
			{
			// the first child of the MinFrame is CMDIFrame
			cf = mf->GetWindow(GW_CHILD);
			if (cf)
			{
			// the first child of CMIDFrame is MDIClient ...
			// now this is the MDI client ....
			
			  
				cf = cf->GetWindow(GW_CHILD);
				// cf is now the first child of the MDI Client window
				
				  while (cf)
				  {
				  // now we iterate through the children ...
				  CString mytxt;
				  cf->GetWindowText(mytxt);
				  
					// the name is added to the search list ....
					mylist.AddTail(mytxt);
					cf =  (cf->GetWindow(GW_HWNDNEXT));
					}
					}
						  }*/
			POSITION pos = GetFirstDocTemplatePosition();
			while(pos)
			{
				CDocTemplate* pTemplate = GetNextDocTemplate(pos); 
				POSITION pos2 = pTemplate->GetFirstDocPosition();
				while(pos2)
				{
					CDocument* pDocument;
					if(pDocument = pTemplate->GetNextDoc(pos2))
					{
						CGmnview32Doc *mydoc = dynamic_cast<CGmnview32Doc *>(pDocument);
						
						if (mydoc)
						{
							CString mystr = mydoc->GetTitle();
							mylist.AddTail(mystr);
						}
					}
				}
			}
			
			
			
			
			// the temporary gmn-file is opened as a new document
			CGmnview32Doc *mydoc = dynamic_cast
				<CGmnview32Doc *>(OpenDocumentFile(tmpgmnname));
			
			// this removes the temporary file from the MRU-List.
			// which is good, because it is only a temporary file
			m_pRecentFileList->Remove(0);
			
			
			// now we try to determine an unused filename ...			
			char chosenname[MAX_PATH];
			
			int i = 0;
			while (true)
			{
				
				// first, we check if the name is already used in
				// the open window file list ....
				char mytmpchar1[MAX_PATH];
				char mytmpchar2[MAX_PATH];
				if (i>0)
				{
					// one variation with star, the other without star
					sprintf(mytmpchar1,"%s%d.gmn *",mdfiletitle,i);
					sprintf(mytmpchar2,"%s%d.gmn",mdfiletitle,i);
				}
				else
				{
					sprintf(mytmpchar1,"%s.gmn *",mdfiletitle);
					sprintf(mytmpchar2,"%s.gmn",mdfiletitle);
				}
				
				if (mylist.Find(mytmpchar1) || mylist.Find(mytmpchar2))
				{
					i++;
					continue;
				}
				
				if (i != 0)
					sprintf(chosenname,"%s\\%s%d.gmn",mdfilepath,
					mdfiletitle,i);
				else 
					sprintf(chosenname,"%s\\%s.gmn",mdfilepath,
					mdfiletitle);
				
				
				if (_access(chosenname,04) == -1)
					break;
				i++;
				if (i == 100)
				{
					sprintf(chosenname,"%s\\fresh_converted.gmn",pathName);
					break;
				}
			}
			
			mydoc->SetTitle(chosenname);
			mydoc->SetPathName(chosenname,FALSE);
			mydoc->SetModifiedFlag(TRUE);
			
			resbool = ::DeleteFile(tmpgmnname);
			
			/*
			// we display the logfile ....
			CM2GConvDialog cd;
			
			int linecountmax = 40;
			int dlgend = 1;
			int fulllog = 0;
			do
			{
				if (!fulllog)
					cd.m_isfulllog = 0;
				else
					cd.m_isfulllog = 1;
				cd.m_logtext = "";
				dlgend = 1;
				// read the logtext from the logfile ....
				CString line;
				CStdioFile mylfile(logfilename,CFile::modeRead);
				
				// the first 40 lines of the file ....
				int linecount = 0;
				while (mylfile.ReadString(line) && linecount < linecountmax)
				{
					linecount++;
					cd.m_logtext += line;
					cd.m_logtext += "\r\n";
				}
				
				mylfile.Close();
				
				if (cd.DoModal() == IDC_FULLLOG)
				{
					
					fulllog = 1;
					dlgend = 0;
					linecountmax = 20000;
				}
				
			}
			while (!dlgend);
			*/
			
		}
		else
		{
			// conversion hat nicht geklappt ... Logfile zeigen...

			MDConvLog cl;
			
			cl.m_titletext = "Conversion of ";
			cl.m_titletext += fileDialog.GetPathName();
			cl.m_titletext += " failed.";

			CStdioFile myfile(logfilename,CFile::modeRead | 
				CFile::typeBinary);

				long length = myfile.GetLength();
				char *buf = (char *) malloc(length+1);
				
				long numread = myfile.ReadHuge(buf,length);
				buf[numread] = 0;
				myfile.Close();
			cl.m_logtext = buf;
			free(buf);

			cl.DoModal();

		}
		
		// have to do this!
		// we also remove the log-file ...
		resbool = ::DeleteFile(logfilename);
		
		
		::SetCursor(old);
		
	} // if (fileDialog.OK);
	
	
}

void CGmnview32App::OnViewDisplayForce() 
{
	// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	
	float f;
	getSetting(6,&f);
	
	if (f == (float) 1)
	{
	// determine if checked ? how to?
		setSetting(6,(float) 0);	
		// do a redisplay ...

	}
	else
	{
		setSetting(6,(float) 1);
		// refresh the view ...
	}

}

void CGmnview32App::OnUpdateViewDisplayForce(CCmdUI* pCmdUI) 
{
	// TODO: Code fr die Befehlsbehandlungsroutine zum Aktualisieren der Benutzeroberflche hier einfgen
	float f;
	getSetting(6,&f);
	if ( (int) f == 1)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);
	
}
